<?php

if ( ! defined( 'FW' ) ) die( 'Forbidden' );

$post_options = array(
    /*page header*/
    'page_header' => array(
        'title'   => esc_html__('General', 'goto'),
        'type'    => 'tab',
        'options' => array(
            /*crumbs header*/
            'p_bread' => array(
                'label'  => false,
                'desc'   => false,
                'type'   => 'multi-picker',
                'picker' => array(
                    'gadget' => array(
                        'label'   => esc_html__('Breadcrumbs', 'goto'),
                        'type'    => 'short-select',
                        'choices' => array(
                            'default' => esc_html__('Default', 'goto'),
                            'custom'  => esc_html__('Custom', 'goto'),
                            'disable' => esc_html__('Disable', 'goto'),
                        ),
                        'value' => 'default',
                    ),
                ),
                'choices' => array(
                    'custom' => array(
                        'p_bread_title' => array(
                            'label' => esc_html__('Alternative Title', 'goto'),
                            'desc'  => esc_html__('This will replace heading page title', 'goto'),
                            'type'  => 'text',
                            'value' => 'This is my title!'
                        ),
                        'p_bread_bg' => array(
                            'label'  => false,
                            'desc'   => false,
                            'type'   => 'multi-picker',
                            'picker' => array(
                                'gadget' => array(
                                    'label'   => esc_html__('Background Style', 'goto'),
                                    'desc'    => esc_html__('If select background image option, the theme recommends a header size of at least 1170 width pixels', 'goto'),
                                    'type'    => 'select',
                                    'choices' => array(
                                        'img_bg'   => esc_html__('Use Image', 'goto'),
                                        'color_bg' => esc_html__('Use Solid Color', 'goto'),
                                    ),
                                    'value' => 'color_bg'
                                )
                            ),
                            'choices' => array(
                                'img_bg' => array(
                                    'img_bg_data' => array(
                                        'label' => esc_html__('Single Upload (Images Only)', 'goto'),
                                        'type'  => 'upload'
                                    )
                                ),
                                'color_bg' => array(
                                    'color_bg_data' => array(
                                        'label' => esc_html__('Background Color', 'goto'),
                                        'type'  => 'color-picker',
                                        'value' => '#e9eceb'
                                    )
                                )
                            ),
                        ),
                    ),
                ),
            ),
        ),
    ),

    /*gallery*/
    'p_gallery' => array(
        'type'    => 'tab',
        'title'   => esc_html__( 'Gallery', 'goto' ),
        'options' => array(
            'd_gallery'       => array(
                'label' => esc_html__( 'Upload', 'goto' ),
                'desc'  => esc_html__( 'Multiple Images for Gallery post format.', 'goto' ),
                'type'  => 'multi-upload',
            ),
            'arrows'       => array(
                'label'       => esc_html__( 'Show arrows', 'goto' ),
                'type'        => 'switch',
                'value'       => true,
                'left-choice' => array(
                    'value' => false,
                    'label' => esc_html__( 'No', 'goto' )
                ),
                'right-choice' => array(
                    'value' => true,
                    'label' => esc_html__( 'Yes', 'goto' )
                ),
            ),
            'dots'       => array(
                'label'       => esc_html__( 'Show dots', 'goto' ),
                'type'        => 'switch',
                'value'       => false,
                'left-choice' => array(
                    'value' => false,
                    'label' => esc_html__( 'No', 'goto' )
                ),
                'right-choice' => array(
                    'value' => true,
                    'label' => esc_html__( 'Yes', 'goto' )
                )
            ),
        )
    ),

    /*video*/
    'p_video' => array(
        'type'    => 'tab',
        'title'   => esc_html__( 'Video', 'goto' ),
        'options' => array(
            'video_type' => array(
                'label'   => esc_html__('Video embed', 'goto'),
                'type'    => 'short-select',
                'choices' => array(
                    'youtube' => esc_html__('Youtube', 'goto'),
                    'vimeo'   => esc_html__('Vimeo', 'goto'),
                ),
                'value' => 'youtube'
            ),
            'video_id' => array(
                'label' => esc_html__('Video ID', 'goto'),
                'desc'  => sprintf(esc_html__( 'Just paste the bold part of the video\'s URL: %1$s%2$s', 'goto' ),
                        '<br>https://youtube.com/watch?v=<b>qDvFdj-pFMc</b>',
                        '<br>https://vimeo.com/<b>119287310</b>'),
                'type'  => 'short-text',
                'value' => 'qDvFdj-pFMc'
            ),
        )
    ),

    /*audio*/
    'p_audio' => array(
        'type' => 'tab',
        'title' => esc_html__( 'Audio', 'goto' ),
        'options' => array(
            'd_audio' => array(
                'label' => esc_html__('Audio SoundCloud', 'goto'),
                'desc' => esc_html__('Input SoundCloud iframe', 'goto'),
                'type' => 'textarea',
            ),
        )
    ),
);

$options = array(
    'post_layout_box' => array(
        'title'   => esc_html__( 'Post Customizing', 'goto'),
        'type'    => 'box',
        'options' => $post_options
    ),
);